<?php

if ( function_exists('register_sidebar') )
  register_sidebar(array(
        'name'=>'サイドバー',
        'id' => '000',
        'before_widget' => '<div class="sidebar_widgets">',
        'after_widget' => '</div>',
        'before_title' => '<h2>',
        'after_title' => '</h2>'
));



//カスタムメニュー
register_nav_menus( array(
    'primary' => 'ヘッダーに入ります'
));



//パンくずナビ
function get_breadcrumbs(){
	global $wp_query;

	if ( !is_home() ){

		// Start the UL
		echo '<ul>';
		// Add the Home link
		echo '<li><a href="'. get_settings('home') .'">'. HOME .'</a></li>';

		if ( is_category() )
		{
			$catTitle = single_cat_title( "", false );
			$cat = get_cat_ID( $catTitle );
			echo "<li> &raquo; ". get_category_parents( $cat, TRUE, "" ) ."</li>";
		}
		elseif ( is_archive() && !is_category() )
		{
			echo "<li> &raquo; Archives</li>";
		}
		elseif ( is_search() ) {

			echo "<li> &raquo; Search Results</li>";
		}
		elseif ( is_404() )
		{
			echo "<li> &raquo; 404 Not Found</li>";
		}
		elseif ( is_single() )
		{
			$category = get_the_category();
			$category_id = get_cat_ID( $category[0]->cat_name );

			echo '<li> &raquo; '. get_category_parents( $category_id, TRUE, " &raquo; " );
			echo the_title('','', FALSE) ."</li>";
		}
		elseif ( is_page() )
		{
			$post = $wp_query->get_queried_object();

			if ( $post->post_parent == 0 ){

				echo "<li> &raquo; ".the_title('','', FALSE)."</li>";

			} else {
				$title = the_title('','', FALSE);
				$ancestors = array_reverse( get_post_ancestors( $post->ID ) );
				array_push($ancestors, $post->ID);

				foreach ( $ancestors as $ancestor ){
					if( $ancestor != end($ancestors) ){
						echo '<li> &raquo; <a href="'. get_permalink($ancestor) .'">'. strip_tags( apply_filters( 'single_post_title', get_the_title( $ancestor ) ) ) .'</a></li>';
					} else {
						echo '<li> &raquo; '. strip_tags( apply_filters( 'single_post_title', get_the_title( $ancestor ) ) ) .'</li>';
					}
				}
			}
		}

		// End the UL
		echo "</ul>";
	}
}



/* アドセンス管理 */
add_action('admin_menu', 'adsense_menu');

function adsense_menu() {
add_menu_page('アドセンス管理', 'アドセンス管理', 8, 'adsense_menu', 'banner_options_page');
add_action( 'admin_init', 'register_banner_settings' );
}

function register_banner_settings() {
  register_setting( 'banner-settings-group', 'banner_001' );
  register_setting( 'banner-settings-group', 'banner_002' );
  register_setting( 'banner-settings-group', 'banner_003' );
}

function banner_options_page() {
?>

<div class="wrap">
<h2>アドセンス管理</h2>

<form method="post" action="options.php">

<?php 
  settings_fields( 'banner-settings-group' );
  do_settings_sections( 'banner-settings-group' );
?>

<table class="form-table">
<tbody>

<tr>
<th scope="row"><label for="banner_001">サイトバー（300×250）</label></th>
<td>
<textarea id="banner_001" class="regular-text" name="banner_001" cols="100" rows="5"><?php echo get_option('banner_001'); ?></textarea>
</td>
</tr>

<tr>
<th scope="row"><label for="banner_002">記事上部（336×280）</label></th>
<td>
<textarea id="banner_002" class="regular-text" name="banner_002" cols="100" rows="5"><?php echo get_option('banner_002'); ?></textarea>
</td>
</tr>

<tr>
<th scope="row"><label for="banner_003">記事下部（336×280）</label></th>
<td>
<textarea id="banner_003" class="regular-text" name="banner_003" cols="100" rows="5"><?php echo get_option('banner_003'); ?></textarea>
</td>
</tr>

</tbody>
</table>

<?php submit_button(); ?>
    
</form>
</div>

<?php
}



//アイキャッチ
add_theme_support('post-thumbnails');
set_post_thumbnail_size( 300, 200, true );
add_image_size('kanren100',100,100,true);
add_image_size('kanren70',70,70,true);



//コメント数だけを取得する関数
function get_comment_only_number() {
    global $wpdb, $tablecomments, $post;
    $comments = $wpdb->get_results("SELECT * FROM $wpdb->comments WHERE comment_post_ID = $post->ID AND
comment_type NOT REGEXP '^(trackback|pingback)$' AND comment_approved = '1'");
    $cnt = count($comments);
    return $cnt;
}



//コメント部分のhtmlを成形する関数
function mytheme_comment($comment, $args, $depth) {
    $GLOBALS['comment'] = $comment; ?>

<li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
<div id="comment-<?php comment_ID(); ?>" class="comment-body">

<div class="comment_out">

<div class="comment_sam">
<?php echo get_avatar( $comment, 50 ); ?>
</div>

<div class="comment_time">
<?php printf(__('<cite class="fn">%s</cite>'), get_comment_author_link()) ?></br>
<?php printf(__('%1$s'), get_comment_date() . ' ' . get_comment_time()) ?><?php edit_comment_link(__('(Edit)'),'  ','') ?>
</div>
</div>

<?php if ($comment->comment_approved == '0') : ?>
<p class="wait">*このコメントはただいま承認待ちです*</p><br />
<?php endif; ?>

            <?php comment_text() ?>
            <div class="reply">
                <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
            </div>
        </div>
<?php }

?>